function [fgSample, bgSample] = loadAnnotation(imgAnnoPath)
%LOADANNOTATION Loads input scribbles
%
%   Input:
%       imgAnnoPath: Path to the image that contains foreground and
%       background scribbles.
% 
%   Output:
%       fgSample: list of pixels belonging to foreground scribbles
%       bgSample: list of pixels belonging to background scribbles
%
% (c) Moustafa Meshry, moustafa.meshry@alexu.edu.eg
%     Department of Compter and Systems Engineering, Alexandria University, Egypt.


    img_rgb = imread(imgAnnoPath);
    
%     fgMask = img_rgb(:,:,1) == 255 & img_rgb(:,:,2) == 0 & ...
%         img_rgb(:,:,3) == 0;
%     bgMask = img_rgb(:,:,1) == 255 & img_rgb(:,:,2) == 255 & ...
%         img_rgb(:,:,3) == 255;
    fgMask = img_rgb(:,:,1) == 1;
    bgMask = img_rgb(:,:,1) == 2;

    
    [x,y] = find(fgMask);
    fgSample = [x y];

    [x,y] = find(bgMask);
    bgSample = [x y];
end

